﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;

namespace GeneratorWerIntPliku
{
   internal class WsparcieMD5
   {
      public const string wzorzecTekstPoczątek = "XXX_BEGIN_WZORZEC_MD5";
      public const string wzorzecTekstKoniec = "XXX_END_WZORZEC_MD5";

      // Postać binarna fragmentów stałej: XXX_BEGIN_WZORZEC_MD5_ i _XXX_END_WZORZEC_MD5
      public const string wzorzecBinPoczątek = "X" + "\0" + "X" + "\0" + "X" + "\0" + "_" + "\0" + "B" + "\0" + "E" + "\0" + "G" +
                           "\0" + "I" + "\0" + "N" + "\0" + "_" + "\0" + "W" + "\0" + "Z" + "\0" + "O" + "\0" + "R" + "\0" +
                           "Z" + "\0" + "E" + "\0" + "C" + "\0" + "_" + "\0" + "M" + "\0" + "D" + "\0" + "5" + "\0" + "_" + "\0";
      public const string wzorzecBinKoniec = "_" + "\0" + "X" + "\0" + "X" + "\0" + "X" + "\0" + "_" + "\0" + "E" + "\0" + "N" +
                           "\0" + "D" + "\0" + "_" + "\0" + "W" + "\0" + "Z" + "\0" + "O" + "\0" + "R" + "\0" +
                           "Z" + "\0" + "E" + "\0" + "C" + "\0" + "_" + "\0" + "M" + "\0" + "D" + "\0" + "5" + "\0";

      public WsparcieMD5(string aŚcieżka)
      {
         _ścieżka = aŚcieżka;
      }
      
      public string MD5Aplikacji()
      {
         string zawartość = PobierzZawartośćPliku();
         // W odczytanym buforze fragment zawierający wzorzec usuwamy, on nie wchodzi w skład danych, którym wyznaczamy md5
         int index_pocz = zawartość.IndexOf(wzorzecBinPoczątek);
         int index_kon = zawartość.IndexOf(wzorzecBinKoniec);
         zawartość = zawartość.Remove(index_pocz, index_kon - index_pocz);
         byte[] bZawartość = System.Text.Encoding.ASCII.GetBytes(zawartość);
         return MD5DlaBajtów(bZawartość);
      }

      public string WzorzecMD5()
      {
         return wzorzecMD5App.Replace(wzorzecTekstPoczątek + "_", "").Replace("_" + wzorzecTekstKoniec, "");
      }

      // Przygotowany wzorzec MD5 aplikacji, 32 zera odpowiadają długością wartości MD5, która powinna być wyznaczona przez inny program
      private const string wzorzecMD5App = "XXX_BEGIN_WZORZEC_MD5_00000000000000000000000000000000_XXX_END_WZORZEC_MD5";

      private string _ścieżka;

      private string MD5DlaBajtów(byte[] bZawartość)
      {
         string md5 = "";
         System.Security.Cryptography.MD5CryptoServiceProvider x = new System.Security.Cryptography.MD5CryptoServiceProvider();
         bZawartość = x.ComputeHash(bZawartość);
         for (int i = 0; i < bZawartość.Length; i++)
            md5 += bZawartość[i].ToString("x2").ToLower();
         return md5;
      }

      private string PobierzZawartośćPliku()
      {
         FileStream fsPlik = new FileStream(_ścieżka, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
         StreamReader srPlik = new StreamReader(fsPlik, System.Text.Encoding.Default);
         string zawartość = srPlik.ReadToEnd();
         srPlik.Close();
         fsPlik.Close();
         return zawartość;
      }

   }
}
